#!/bin/bash
cd ../..
# custom config
DATA=***
TRAINER=APPLe

#DATASET="imagenet"
#DATASET="stanford_cars"
#DATASET="sun397"
#DATASET="caltech101"
DATASET="oxford_pets"
#DATASET="oxford_flowers"
#DATASET="dtd"
#DATASET="fgvc_aircraft"
#DATASET="eurosat"
#DATASET="ucf101"
#DATASET="food101"

SEED=$1

CFG=vit_b16_c4_ep10_batch32_ctxv1
SHOTS=16
LOADEP=50
SUB=new

COMMON_DIR=${DATASET}/shots_${SHOTS}/${TRAINER}/${CFG}_${DATASET}/seed${SEED}
MODEL_DIR=output/base2new/train_base/${COMMON_DIR}
DIR=output/base2new/test_${SUB}/${COMMON_DIR}
if [ -d "$DIR" ]; then
    echo "Oops! The results exist at ${DIR} (so skip this job)"
else
    python train.py \
    --root ${DATA} \
    --seed ${SEED} \
    --trainer ${TRAINER} \
    --dataset-config-file configs/datasets/${DATASET}.yaml \
    --config-file configs/trainers/${TRAINER}/${CFG}_imagenet_DG.yaml \
    --output-dir ${DIR} \
    --model-dir ${MODEL_DIR} \
    --load-epoch ${LOADEP} \
    --eval-only \
    --DG \
    DATASET.NUM_SHOTS ${SHOTS} \
    DATASET.SUBSAMPLE_CLASSES all
fi
